//
//  MortalityIndicator.swift
//  death_app Watch App
//
//  Created by Task Master on 2025-09-16.
//

import SwiftUI

enum HealthChangeState {
    case neutral
    case positive
    case negative
}

struct MortalityIndicator: View {
    let healthChangeState: HealthChangeState
    let changeSeverity: Double // 0.0 to 1.0
    
    @State private var animationOffset: CGFloat = 0
    @State private var opacity: Double = 1.0
    
    var body: some View {
        ZStack {
            switch healthChangeState {
            case .neutral:
                neutralIndicator
            case .positive:
                LifeBoostView(severity: changeSeverity)
            case .negative:
                GrimReaperView(severity: changeSeverity)
            }
        }
        .animation(.easeInOut(duration: 0.6), value: healthChangeState)
        .accessibility(label: Text(accessibilityDescription))
    }
    
    private var neutralIndicator: some View {
        VStack(spacing: 4) {
            Image(systemName: "heart.circle")
                .font(.title2)
                .foregroundColor(.secondary)
            
            Text("Stable")
                .font(.caption2)
                .foregroundColor(.secondary)
        }
        .opacity(0.6)
    }
    
    private var accessibilityDescription: String {
        switch healthChangeState {
        case .neutral:
            return "Health status is stable"
        case .positive:
            return "Health status is improving"
        case .negative:
            return "Health status is declining"
        }
    }
}

#Preview {
    VStack(spacing: 20) {
        MortalityIndicator(healthChangeState: .neutral, changeSeverity: 0.0)
        MortalityIndicator(healthChangeState: .positive, changeSeverity: 0.7)
        MortalityIndicator(healthChangeState: .negative, changeSeverity: 0.5)
    }
    .padding()
}